/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	WindowColorsWindow.cpp
	
	Contains:	Implementation of smart window.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _WINDOW_COLORS_WINDOW_H
#include "WindowColorsWindow.h"
#endif


/* ...............................................................	
	String constants
	The name of the window and the name of the entry in the
	settings message that contains the window location.
   ............................................................... */

const char *PREFERENCE_WINDOW_NAME	= "Window Colors";
const char *WINDOW_LOCATION_ENTRY 	= "window_location";


/* ...............................................................	
	WindowColorsWindow constructor
	Creates and adds the background panel view, positions the
	view based on the location stored for it in the settings
	message, and makes sure it's still on screen.
   ............................................................... */

WindowColorsWindow::WindowColorsWindow()
				   :BWindow(WINDOW_FRAME, PREFERENCE_WINDOW_NAME, 
				  		    B_TITLED_WINDOW, 
				  		    B_NOT_RESIZABLE | B_NOT_ZOOMABLE),
				    _panel(NULL),
				    _aboutPanel(NULL)
{
	/* Create the about view, but hide it */
	_aboutPanel = new AboutPanel(Bounds());
	AddChild(_aboutPanel);
	_aboutPanel->Hide();

	/* Create the main panel view */
	_panel = new WindowColorsPanel(Bounds());
	AddChild(_panel);
	
	/* Get the location to place the window from the settings
	   message and move the window there. */
	BPoint location;
	if (window_colors_app->Settings()
		->FindPoint(WINDOW_LOCATION_ENTRY, &location) != B_OK)
		location.Set(DEFAULT_WINDOW_LOCATION.x,
					 DEFAULT_WINDOW_LOCATION.y);
	MoveTo(location);
	
	/* In case we're off the screen... */
	KeepOnScreen();
}


/* ...............................................................	
	WindowColorsWindow::QuitRequested()
	Overridden to quit the application when we quit.
   ............................................................... */

bool WindowColorsWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}


/* ...............................................................	
	WindowColorsWindow::Quit()
	Overridden to save the last position when we quit.
   ............................................................... */

void WindowColorsWindow::Quit()
{
	BMessage *settings = window_colors_app->Settings();
	if (settings->HasPoint("window_location"))
		settings->ReplacePoint("window_location", 0, Frame().LeftTop());
	else
		settings->AddPoint("window_location", Frame().LeftTop());
	BWindow::Quit();
}


/* ...............................................................	
	WindowColorsWindow::ScreenChanged()
	Keeps the window on screen.
   ............................................................... */

void WindowColorsWindow::ScreenChanged(BRect screenFrame, 
								       color_space depth)
{
#pragma unused(depth, screenFrame)
	/* Make sure we're still on the screen */
	KeepOnScreen();
	
	/* Reset the value of the color control quietly */
	_panel->GetColorPicker()->SetValueQuietly(_panel->
											  FocusedColorLabel()->
											  Color());
}


/* ...............................................................	
	WindowColorsWindow::KeepOnScreen()
	Keeps the window on screen.
   ............................................................... */

void WindowColorsWindow::KeepOnScreen()
{
	BScreen screen;
	BRect	screenFrame = screen.Frame();
	BPoint	newOrigin = Frame().LeftTop();
	
	if (newOrigin.x > screenFrame.right)
		newOrigin.x = screenFrame.right - 100;
	if (newOrigin.y > screenFrame.bottom)
		newOrigin.y = screenFrame.bottom - 100;
	MoveTo(newOrigin);
}


/* ...............................................................	
	WindowColorsWindow::Panel()
	Simply returns the WindowColorsPanel child view.
   ............................................................... */

WindowColorsPanel *WindowColorsWindow::Panel()
{
	return _panel;
}


/* ...............................................................	
	WindowColorsWindow::SetAboutView()
	Sets whether or not the AboutView is showing.
   ............................................................... */

void WindowColorsWindow::ShowAboutPanel(bool show)
{
	if (show == true)
	{
		if (_aboutPanel->IsHidden())
			_aboutPanel->Show();

		if (! _panel->IsHidden())
			_panel->Hide();
	}
	else
	{
		if (_panel->IsHidden())
			_panel->Show();

		if (! _aboutPanel->IsHidden())
			_aboutPanel->Hide();
	}
}